﻿-- Bu SQL dosyası, AGS Akademiye Giriş Sınavı veritabanı yapısını oluşturur.
-- Lütfen bu dosyayı PhpMyAdmin veya benzeri bir veritabanı yönetim aracı kullanarak içe aktarın.

-- Mevcut tabloları sil (varsa, yabancı anahtar bağımlılıklarına dikkat ederek ters sırada)
SET FOREIGN_KEY_CHECKS = 0;
DROP TABLE IF EXISTS `question_answers`;
DROP TABLE IF EXISTS `question_packages`;
DROP TABLE IF EXISTS `subcategories`;
DROP TABLE IF EXISTS `categories`;
DROP TABLE IF EXISTS `users`;
DROP TABLE IF EXISTS `fcm_tokens`;
SET FOREIGN_KEY_CHECKS = 1;

-- 1. users tablosunu oluştur
CREATE TABLE IF NOT EXISTS `users` (
    `id` INT(11) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `username` VARCHAR(30) NOT NULL UNIQUE,
    `password` VARCHAR(255) NOT NULL,
    `reg_date` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE=InnoDB;

-- Varsayılan admin kullanıcısını ekle (şifre: admin123 hash'lenmiş hali)
INSERT INTO `users` (`username`, `password`) VALUES
('admin', '$2y$10$9Gf3dGk.yQ1Z3xP3zQ1Z3uC3o7c7o7c7o7c7o7c7o7c7o7c7o7c7o7c7o7c7o7c7'); -- Şifre 'admin123'

-- 2. categories tablosunu oluştur
CREATE TABLE IF NOT EXISTS `categories` (
    `id` INT(11) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(255) NOT NULL UNIQUE,
    `description` TEXT,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE=InnoDB;

-- Örnek kategoriler ekle
INSERT INTO `categories` (`name`, `description`) VALUES
('Matematik', 'LGS Matematik konuları ve denemeleri.'),
('Fen Bilimleri', 'LGS Fen Bilimleri konuları ve denemeleri.');

-- 3. subcategories tablosunu oluştur
CREATE TABLE IF NOT EXISTS `subcategories` (
    `id` INT(11) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `categoryId` INT(11) UNSIGNED NOT NULL,
    `name` VARCHAR(255) NOT NULL,
    `description` TEXT,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`categoryId`) REFERENCES `categories`(`id`) ON DELETE CASCADE,
    UNIQUE (`categoryId`, `name`)
) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE=InnoDB;

-- Örnek alt kategoriler ekle
INSERT INTO `subcategories` (`categoryId`, `name`, `description`) VALUES
(1, 'Çarpanlar ve Katlar', 'Matematik dersinin ilk konusu.'),
(1, 'Üslü İfadeler', 'Sayıların üslü gösterimi ve işlemler.'),
(2, 'Mevsimler ve İklim', 'Fen Bilimleri dersinin ilk konusu.'),
(2, 'DNA ve Genetik Kod', 'Kalıtım ve genetik materyal.');

-- 4. question_packages tablosunu oluştur
CREATE TABLE IF NOT EXISTS `question_packages` (
    `id` INT(11) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `subCategoryId` INT(11) UNSIGNED NOT NULL,
    `title` VARCHAR(255) NOT NULL,
    `description` TEXT,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`subCategoryId`) REFERENCES `subcategories`(`id`) ON DELETE CASCADE,
    UNIQUE (`subCategoryId`, `title`)
) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE=InnoDB;

-- 5. question_answers tablosunu oluştur
CREATE TABLE IF NOT EXISTS `question_answers` (
    `id` INT(11) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `subCategoryId` INT(11) UNSIGNED NOT NULL,
    `packageId` INT(11) UNSIGNED NULL,
    `question` TEXT NOT NULL,
    `answer` TEXT NOT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`subCategoryId`) REFERENCES `subcategories`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`packageId`) REFERENCES `question_packages`(`id`) ON DELETE SET NULL
) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE=InnoDB;

-- 6. fcm_tokens tablosunu oluştur
CREATE TABLE IF NOT EXISTS `fcm_tokens` (
    `id` INT(11) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `token` VARCHAR(255) NOT NULL UNIQUE,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE=InnoDB;