<?php
header("Content-Type: application/json");

require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/FcmService.php';

// Gelen isteğin POST olup olmadığını kontrol et
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // JSON olarak gelen veriyi al
    $data = json_decode(file_get_contents("php://input"), true);

    // Token'ı al
    $fcmToken = $data['fcm_token'] ?? null;

    if ($fcmToken) {
        $fcmService = new FcmService($conn);
        if ($fcmService->registerToken($fcmToken)) {
            echo json_encode(['status' => 'success', 'message' => 'FCM token başarıyla kaydedildi.']);
        } else {
            http_response_code(500);
            echo json_encode(['status' => 'error', 'message' => 'FCM token kaydedilirken bir hata oluştu.']);
        }
    } else {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'FCM token sağlanmadı.']);
    }
} else {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Sadece POST istekleri kabul edilir.']);
}

$conn->close();
?> 