<?php
require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/QuestionAnswerService.php';
require_once __DIR__ . '/../config.php'; // API_KEY için

header('Content-Type: application/json; charset=UTF-8');

$questionAnswerService = new QuestionAnswerService($conn);

$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        $id = isset($_GET['id']) ? intval($_GET['id']) : 0;
        $subCategoryId = isset($_GET['subCategoryId']) ? intval($_GET['subCategoryId']) : 0;
        $packageId = isset($_GET['packageId']) ? intval($_GET['packageId']) : 0;
        $includeNullPackageId = isset($_GET['includeNullPackageId']) && $_GET['includeNullPackageId'] == 'true';

        if ($id > 0) {
            $qa = $questionAnswerService->getQuestionAnswerById($id);
            if ($qa) {
                echo json_encode(['status' => 'success', 'data' => $qa]);
            } else {
                http_response_code(404);
                echo json_encode(['status' => 'error', 'message' => 'Soru-Cevap bulunamadı.']);
            }
        } else {
            $questions = $questionAnswerService->getQuestionAnswersByFilters($subCategoryId, $packageId, $includeNullPackageId);
            echo json_encode(['status' => 'success', 'data' => $questions]);
        }
        break;
    
    default:
        http_response_code(405);
        echo json_encode(['status' => 'error', 'message' => 'Desteklenmeyen istek metodu.']);
        break;
}

$conn->close();
?> 