<?php
require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/SubcategoryService.php';
require_once __DIR__ . '/../services/CategoryService.php'; // Kategorileri çekmek için
require_once __DIR__ . '/../helpers/session_helper.php';

check_admin_session(); // Admin oturumunu kontrol et

$subcategoryService = new SubcategoryService($conn);
$categoryService = new CategoryService($conn); // Kategorileri çekmek için servis

// Alt kategori ekleme veya güncelleme işlemleri
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['action']) && $_POST['action'] == 'add_subcategory') {
        $categoryId = intval($_POST['categoryId']);
        $name = trim($_POST['name']);
        $description = trim($_POST['description']);
        
        if (empty($name) || $categoryId <= 0) {
            set_session_message('error', "Alt kategori adı ve kategori seçimi boş bırakılamaz.");
        } else {
            $result = $subcategoryService->addSubcategory($categoryId, $name, $description);
            set_session_message($result['status'], $result['message']);
        }
    } elseif (isset($_POST['action']) && $_POST['action'] == 'edit_subcategory') {
        $id = intval($_POST['subcategory_id']);
        $categoryId = intval($_POST['categoryId']);
        $name = trim($_POST['name']);
        $description = trim($_POST['description']);

        if (empty($name) || $categoryId <= 0) {
            set_session_message('error', "Alt kategori adı ve kategori seçimi boş bırakılamaz.");
        } else {
            $result = $subcategoryService->updateSubcategory($id, $categoryId, $name, $description);
            set_session_message($result['status'], $result['message']);
        }
    }
    header("Location: subcategories.php"); // POST işlemi sonrası sayfayı yenile
    exit;
}

// Alt kategori silme işlemi
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $result = $subcategoryService->deleteSubcategory($id);
    set_session_message($result['status'], $result['message']);
    header("Location: subcategories.php");
    exit;
}

// Tüm alt kategorileri ve kategorileri çek
$subcategories = $subcategoryService->getAllSubcategoriesWithCategoryNames();
$categories = $categoryService->getAllCategories(); // Kategori seçim kutusu için

include '_head.php'; // Header'ı dahil et
?>

<h1 class="mb-4">Alt Kategoriler</h1>
<?php display_session_message(); // Oturum mesajlarını göster ?>

<button type="button" class="btn btn-success mb-3" data-bs-toggle="modal" data-bs-target="#addSubcategoryModal">
    Yeni Alt Kategori Ekle
</button>

<div class="table-responsive">
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th>ID</th>
                <th>Kategori</th>
                <th>Alt Kategori Adı</th>
                <th>Açıklama</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($subcategories)): ?>
                <?php foreach ($subcategories as $subcategory): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($subcategory['id']); ?></td>
                        <td><?php echo htmlspecialchars($subcategory['category_name']); ?></td>
                        <td><?php echo htmlspecialchars($subcategory['name']); ?></td>
                        <td><?php echo htmlspecialchars($subcategory['description']); ?></td>
                        <td>
                            <button type="button" class="btn btn-sm btn-primary edit-btn" 
                                data-id="<?php echo htmlspecialchars($subcategory['id']); ?>" 
                                data-category-id="<?php echo htmlspecialchars($subcategory['categoryId']); ?>" 
                                data-name="<?php echo htmlspecialchars($subcategory['name']); ?>" 
                                data-description="<?php echo htmlspecialchars($subcategory['description']); ?>"
                                data-bs-toggle="modal" data-bs-target="#editSubcategoryModal">
                                Düzenle
                            </button>
                            <a href="subcategories.php?action=delete&id=<?php echo htmlspecialchars($subcategory['id']); ?>" 
                                class="btn btn-sm btn-danger" 
                                onclick="return confirm('Bu alt kategoriyi silmek istediğinizden emin misiniz? Bu işlem geri alınamaz!');">
                                Sil
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="5" class="text-center">Henüz hiç alt kategori yok.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Yeni Alt Kategori Ekle Modal -->
<div class="modal fade" id="addSubcategoryModal" tabindex="-1" aria-labelledby="addSubcategoryModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="addSubcategoryModalLabel">Yeni Alt Kategori Ekle</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <div class="modal-body">
          <input type="hidden" name="action" value="add_subcategory">
          <div class="mb-3">
            <label for="add_categoryId" class="form-label">Kategori Seçin</label>
            <select class="form-select" id="add_categoryId" name="categoryId" required>
              <option value="">Kategori Seçiniz...</option>
              <?php foreach ($categories as $cat): ?>
                <option value="<?php echo htmlspecialchars($cat['id']); ?>"><?php echo htmlspecialchars($cat['name']); ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-3">
            <label for="add_name" class="form-label">Alt Kategori Adı</label>
            <input type="text" class="form-control" id="add_name" name="name" required>
          </div>
          <div class="mb-3">
            <label for="add_description" class="form-label">Açıklama (İsteğe Bağlı)</label>
            <textarea class="form-control" id="add_description" name="description" rows="3"></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
          <button type="submit" class="btn btn-primary">Alt Kategori Ekle</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Alt Kategori Düzenle Modal -->
<div class="modal fade" id="editSubcategoryModal" tabindex="-1" aria-labelledby="editSubcategoryModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editSubcategoryModalLabel">Alt Kategori Düzenle</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <div class="modal-body">
          <input type="hidden" name="action" value="edit_subcategory">
          <input type="hidden" name="subcategory_id" id="edit_subcategory_id">
          <div class="mb-3">
            <label for="edit_categoryId" class="form-label">Kategori Seçin</label>
            <select class="form-select" id="edit_categoryId" name="categoryId" required>
              <option value="">Kategori Seçiniz...</option>
              <?php foreach ($categories as $cat): ?>
                <option value="<?php echo htmlspecialchars($cat['id']); ?>"><?php echo htmlspecialchars($cat['name']); ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-3">
            <label for="edit_name" class="form-label">Alt Kategori Adı</label>
            <input type="text" class="form-control" id="edit_name" name="name" required>
          </div>
          <div class="mb-3">
            <label for="edit_description" class="form-label">Açıklama (İsteğe Bağlı)</label>
            <textarea class="form-control" id="edit_description" name="description" rows="3"></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
          <button type="submit" class="btn btn-primary">Değişiklikleri Kaydet</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        var editSubcategoryModal = document.getElementById('editSubcategoryModal');
        editSubcategoryModal.addEventListener('show.bs.modal', function (event) {
            // Tetikleyen butonu al
            var button = event.relatedTarget;

            // Data özelliklerinden bilgileri çek
            var id = button.getAttribute('data-id');
            var categoryId = button.getAttribute('data-category-id');
            var name = button.getAttribute('data-name');
            var description = button.getAttribute('data-description');

            // Modaldaki input alanlarını doldur
            var modalIdInput = editSubcategoryModal.querySelector('#edit_subcategory_id');
            var modalCategoryIdSelect = editSubcategoryModal.querySelector('#edit_categoryId');
            var modalNameInput = editSubcategoryModal.querySelector('#edit_name');
            var modalDescriptionInput = editSubcategoryModal.querySelector('#edit_description');

            modalIdInput.value = id;
            modalCategoryIdSelect.value = categoryId; // Select elemanı için value ile seçimi yap
            modalNameInput.value = name;
            modalDescriptionInput.value = description;
        });
    });
</script>

<?php include '_footer.php'; // Footer'ı dahil et ?> 