            </main>
        </div>
    </div>

    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>

    <!-- Toast Container -->
    <div aria-live="polite" aria-atomic="true" class="toast-container position-fixed bottom-0 end-0 p-3">
        <!-- Toasts will be appended here -->
    </div>

    <script>
        // Sayfa yüklendiğinde mevcut sayfanın navigasyon bağlantısını aktif işaretle
        document.addEventListener('DOMContentLoaded', function() {
            var currentPath = window.location.pathname.split('/').pop();
            var navLinks = document.querySelectorAll('.sidebar .nav-link');
            navLinks.forEach(function(link) {
                if (link.getAttribute('href') === currentPath) {
                    link.classList.add('active');
                    link.setAttribute('aria-current', 'page');
                } else {
                    link.classList.remove('active');
                    link.removeAttribute('aria-current');
                }
            });

            // Oturum mesajını al ve Toast olarak göster
            const sessionMessageDataElement = document.getElementById('session-message-data');
            if (sessionMessageDataElement) {
                try {
                    const messageData = JSON.parse(sessionMessageDataElement.getAttribute('data-message'));

                    if (messageData && messageData.content) {
                        const toastContainer = document.querySelector('.toast-container');
                        const toastHtml = `
                            <div class="toast align-items-center text-white bg-${messageData.type} border-0" role="alert" aria-live="assertive" aria-atomic="true">
                                <div class="d-flex">
                                    <div class="toast-body">
                                        ${messageData.content}
                                    </div>
                                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
                                </div>
                            </div>
                        `;
                        toastContainer.insertAdjacentHTML('beforeend', toastHtml);

                        // Son eklenen toast'ı bul ve göster
                        const lastToastEl = toastContainer.lastElementChild;
                        const toast = new bootstrap.Toast(lastToastEl);
                        toast.show();

                        // Mesajı gösterdikten sonra data elementini kaldır
                        sessionMessageDataElement.remove();
                    }
                } catch (e) {
                    console.error("Error parsing session message data:", e);
                }
            }
        });
    </script>
</body>
</html> 