<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Debug log dosyası
$logFile = __DIR__ . '/csv_upload_debug.log';
file_put_contents($logFile, "\n\n--- Yeni Yükleme Denemesi: " . date("Y-m-d H:i:s") . " ---\n", FILE_APPEND);

function write_log($message) {
    global $logFile;
    file_put_contents($logFile, $message . "\n", FILE_APPEND);
}

write_log("upload_questions_csv.php başlatıldı.");

require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../helpers/session_helper.php';
require_once __DIR__ . '/../services/SubcategoryService.php';
require_once __DIR__ . '/../services/QuestionAnswerService.php';

check_admin_session(); // Admin oturumunu kontrol et

// Sadece POST isteklerini kabul et
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    set_session_message('error', 'Geçersiz istek metodu.');
    write_log("Geçersiz istek metodu.");
    header('Location: question_answers.php');
    exit;
}

// Dosya yükleme hatası kontrolü
if (!isset($_FILES['csvFile']) || $_FILES['csvFile']['error'] !== UPLOAD_ERR_OK) {
    set_session_message('error', 'Dosya yükleme hatası.');
    write_log("Dosya yükleme hatası: " . ($_FILES['csvFile']['error'] ?? 'Bilinmiyor'));
    header('Location: question_answers.php');
    exit;
}

$csvFile = $_FILES['csvFile'];
$fileTmpPath = $csvFile['tmp_name'];
$fileName = $csvFile['name'];
$fileSize = $csvFile['size'];
$fileType = $csvFile['type'];
$fileNameCmps = explode(".", $fileName);
$fileExtension = strtolower(end($fileNameCmps));

write_log("Yüklenen dosya: " . $fileName . ", Boyut: " . $fileSize . ", Tip: " . $fileType);

// Dosya uzantısı kontrolü
$allowedfileExtensions = array('csv');
if (!in_array($fileExtension, $allowedfileExtensions)) {
    set_session_message('error', 'Sadece .csv uzantılı dosyalar yüklenebilir.');
    write_log("Geçersiz dosya uzantısı: " . $fileExtension);
    header('Location: question_answers.php');
    exit;
}

// Dosya boyutu kontrolü (isteğe bağlı, php.ini ayarlarınıza da bağlıdır)
// if ($fileSize > 2 * 1024 * 1024) { // 2MB limit
//     set_session_message('error', 'Dosya boyutu çok büyük (Max 2MB).');
//     header('Location: question_answers.php');
//     exit;
// }

// Formdan gelen kategori, alt kategori ve paket ID'lerini al
$selectedCategoryId = isset($_POST['categoryId']) ? intval($_POST['categoryId']) : 0;
$selectedSubcategoryId = isset($_POST['subCategoryId']) ? intval($_POST['subCategoryId']) : 0;
$selectedPackageId = isset($_POST['packageId']) && $_POST['packageId'] !== '' ? intval($_POST['packageId']) : NULL;

write_log("Seçilen Kategori ID: " . $selectedCategoryId . ", Alt Kategori ID: " . $selectedSubcategoryId . ", Paket ID: " . ($selectedPackageId ?? 'NULL'));

// Alt kategori seçimi zorunlu
if ($selectedSubcategoryId <= 0) {
    set_session_message('error', 'Lütfen bir alt kategori seçin.');
    write_log("Alt kategori seçilmedi.");
    header('Location: question_answers.php');
    exit;
}

// Veritabanı servislerini başlat
// SubcategoryService artık CSV okuma için kullanılmıyor
$questionAnswerService = new QuestionAnswerService($conn);

$successful_imports = 0;
$failed_imports = 0;
$error_messages = [];
$row_number = 0;

// CSV dosyasını oku
if (($handle = fopen($fileTmpPath, "r")) !== FALSE) {
    write_log("CSV dosyası açıldı.");

    // BOM'u kontrol et ve kaldır
    $bom = fread($handle, 3);
    if ($bom !== "\xef\xbb\xbf") {
        fseek($handle, 0); // BOM yoksa dosyanın başına dön
    }
    write_log("BOM kontrolü yapıldı. İlk 3 byte: " . bin2hex($bom));

    // Başlık satırını oku
    $header = fgetcsv($handle, 1000, ";");
    write_log("CSV Başlık satırı: " . var_export($header, true));
    
    // Beklenen sütun başlıklarının indekslerini bul
    $questionIndex = array_search('Soru', $header);
    $answerIndex = array_search('Cevap', $header);

    write_log("Soru Index: " . var_export($questionIndex, true) . ", Cevap Index: " . var_export($answerIndex, true));

    // Gerekli sütunların varlığını kontrol et
    if ($questionIndex === FALSE || $answerIndex === FALSE) {
         set_session_message('error', 'CSV dosyasında gerekli sütun başlıkları (Soru, Cevap) bulunamadı.');
         write_log("Hata: Gerekli sütun başlıkları bulunamadı.");
         fclose($handle);
         header('Location: question_answers.php');
         exit;
    }

    // Her satırı oku ve işle
    while (($data = fgetcsv($handle, 1000, ";")) !== FALSE) {
        $row_number++;
        write_log("Satır $row_number okundu: " . var_export($data, true));

        // Sütun sayısı yetersizse bu satırı atla
        if (count($data) <= max($questionIndex, $answerIndex)) {
            $failed_imports++;
            $error_messages[] = "Satır $row_number: Yetersiz sütun sayısı veya boş satır.";
            write_log("Satır $row_number: Yetersiz sütun sayısı veya boş satır. Data: " . var_export($data, true));
            continue;
        }
        
        // Soru ve Cevap sütunlarını al
        $question = trim($data[$questionIndex]);
        $answer = trim($data[$answerIndex]);
        
        write_log("Satır $row_number - Soru: '" . $question . "', Cevap: '" . $answer . "'");

        // Temel veri doğrulaması
        if (empty($question) || empty($answer)) {
            $failed_imports++;
            $error_messages[] = "Satır $row_number: Gerekli alanlar (Soru, Cevap) boş bırakılamaz.";
            write_log("Satır $row_number: Gerekli alanlar boş. Soru: '" . $question . "', Cevap: '" . $answer . "'");
            continue;
        }

        // Soru-Cevabı veritabanına ekle
        $addResult = $questionAnswerService->addQuestionAnswer($selectedSubcategoryId, $selectedPackageId, $question, $answer);
        write_log("Satır $row_number - Veritabanı ekleme sonucu: " . var_export($addResult, true));

        if ($addResult['status'] === 'success') {
            $successful_imports++;
        } else {
            $failed_imports++;
            $error_messages[] = "Satır $row_number: " . $addResult['message'];
            write_log("Satır $row_number - Veritabanı ekleme hatası: " . $addResult['message']);
        }
    }
    fclose($handle);

    // İşlem özeti mesajını hazırla
    $summary_message = "CSV yükleme işlemi tamamlandı. Başarılı: {$successful_imports}, Başarısız: {$failed_imports}.";
    if ($failed_imports > 0) {
        $summary_message .= " Hatalar: " . implode("; ", $error_messages);
        set_session_message('warning', $summary_message); // Hata varsa uyarı göster
        write_log("Özet Mesaj (Uyarı): " . $summary_message);
    } else {
        set_session_message('success', $summary_message); // Hata yoksa başarı göster
        write_log("Özet Mesaj (Başarı): " . $summary_message);
    }

} else {
    set_session_message('error', 'CSV dosyası okunamadı.');
    write_log("Hata: CSV dosyası açılamadı.");
}

// question_answers.php sayfasına geri yönlendir
header('Location: question_answers.php');
exit;

?> 