<?php
require_once __DIR__ . '/../helpers/session_helper.php';
require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/QuestionAnswerService.php';
require_once __DIR__ . '/../services/CategoryService.php'; // Kategoriler için
require_once __DIR__ . '/../services/SubcategoryService.php'; // Alt Kategoriler için
// Eğer kullanıcı raporları da gösterilecekse UserService'i de dahil edin.
// require_once __DIR__ . '/../services/UserService.php';

check_admin_session(); // Admin oturumunu kontrol et

$questionAnswerService = new QuestionAnswerService($conn);
$categoryService = new CategoryService($conn);
$subcategoryService = new SubcategoryService($conn);
// $userService = new UserService($conn);

// Raporlar için gerekli verileri çekme
$questionsByCategory = $questionAnswerService->getQuestionCountByCategory();
$questionsBySubcategory = $questionAnswerService->getQuestionCountBySubcategory();
$questionsByPackage = $questionAnswerService->getQuestionCountByPackage();
$latestQuestions = $questionAnswerService->getLatestQuestions(10); // Son 10 soru

include '_head.php'; // Header'ı dahil et
?>

<h1 class="mb-4">Raporlar</h1>
<?php display_session_message(); // Oturum mesajlarını göster (artık Toast olarak görünmeli) ?>

<div class="row">
    <div class="col-md-12">
        <div class="alert alert-info" role="alert">
            Detaylı raporlar burada gösterilecektir.
        </div>
    </div>
</div>

<!-- Kategori Bazında Soru Sayısı Raporu -->
<div class="card mb-4">
    <div class="card-header">
        Kategori Bazında Soru Sayıları
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>Kategori Adı</th>
                        <th>Soru Sayısı</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($questionsByCategory)): ?>
                        <?php foreach ($questionsByCategory as $report): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($report['category_name']); ?></td>
                                <td><?php echo htmlspecialchars($report['question_count']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="2" class="text-center">Kategori bazında soru verisi bulunamadı.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Alt Kategori Bazında Soru Sayısı Raporu -->
<div class="card mb-4">
    <div class="card-header">
        Alt Kategori Bazında Soru Sayıları
    </div>
    <div class="card-body">
         <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>Kategori > Alt Kategori</th>
                        <th>Soru Sayısı</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($questionsBySubcategory)): ?>
                        <?php foreach ($questionsBySubcategory as $report): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($report['category_name']) . ' > ' . htmlspecialchars($report['subcategory_name']); ?></td>
                                <td><?php echo htmlspecialchars($report['question_count']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="2" class="text-center">Alt kategori bazında soru verisi bulunamadı.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Paket Bazında Soru Sayısı Raporu -->
<div class="card mb-4">
    <div class="card-header">
        Soru Paketi Bazında Soru Sayıları
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>Alt Kategori > Paket Adı</th>
                        <th>Soru Sayısı</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($questionsByPackage)): ?>
                        <?php foreach ($questionsByPackage as $report): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($report['subcategory_name']) . ' > ' . htmlspecialchars($report['package_title']); ?></td>
                                <td><?php echo htmlspecialchars($report['question_count']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="2" class="text-center">Paket bazında soru verisi bulunamadı.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Son Eklenen Sorular Raporu -->
<div class="card mb-4">
    <div class="card-header">
        Son Eklenen 10 Soru
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Alt Kategori</th>
                        <th>Soru Paketi</th>
                        <th>Soru</th>
                        <th>Cevap</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($latestQuestions)): ?>
                        <?php foreach ($latestQuestions as $question): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($question['id']); ?></td>
                                <td><?php echo htmlspecialchars($question['subcategory_name']); ?></td>
                                <td><?php echo htmlspecialchars($question['package_title'] ?? 'Yok'); ?></td>
                                <td><?php echo $question['question']; ?></td> <!-- HTMLspecialchars zaten Service metodunda yapıldı -->
                                <td><?php echo $question['answer']; ?></td>   <!-- HTMLspecialchars zaten Service metodunda yapıldı -->
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center">Son eklenen soru bulunamadı.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>


<?php include '_footer.php'; // Footer'ı dahil et ?> 