<?php
require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/QuestionAnswerService.php';
require_once __DIR__ . '/../services/SubcategoryService.php'; // Alt kategorileri çekmek için
require_once __DIR__ . '/../helpers/session_helper.php';
require_once __DIR__ . '/../services/CategoryService.php'; // Kategorileri çekmek için

check_admin_session(); // Admin oturumunu kontrol et

$questionAnswerService = new QuestionAnswerService($conn);
$subcategoryService = new SubcategoryService($conn);
$categoryService = new CategoryService($conn); // Yeni eklendi

// Tekli Soru-Cevap ekleme veya güncelleme işlemleri
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['action']) && $_POST['action'] == 'add_qa') {
        $subCategoryId = intval($_POST['subCategoryId']);
        $packageId = isset($_POST['packageId']) && $_POST['packageId'] !== '' ? intval($_POST['packageId']) : NULL;
        $question = trim($_POST['question']);
        $answer = trim($_POST['answer']);
        
        if (empty($question) || empty($answer) || $subCategoryId <= 0) {
            set_session_message('error', "Soru, cevap ve alt kategori seçimi boş bırakılamaz.");
        } else {
            $result = $questionAnswerService->addQuestionAnswer($subCategoryId, $packageId, $question, $answer);
            set_session_message($result['status'], $result['message']);
        }
    } elseif (isset($_POST['action']) && $_POST['action'] == 'edit_qa') {
        $id = intval($_POST['qa_id']);
        $subCategoryId = intval($_POST['subCategoryId']);
        $packageId = isset($_POST['packageId']) && $_POST['packageId'] !== '' ? intval($_POST['packageId']) : NULL;
        $question = trim($_POST['question']);
        $answer = trim($_POST['answer']);

        if (empty($question) || empty($answer) || $subCategoryId <= 0) {
            set_session_message('error', "Soru, cevap ve alt kategori seçimi boş bırakılamaz.");
        } else {
            $result = $questionAnswerService->updateQuestionAnswer($id, $subCategoryId, $question, $answer, $packageId);
            set_session_message($result['status'], $result['message']);
        }
    }
    
    // Sadece tekli ekleme/güncelleme POST işlemleri sonrası yönlendir
    if(isset($_POST['action']) && ($_POST['action'] == 'add_qa' || $_POST['action'] == 'edit_qa')) {
        header("Location: question_answers.php");
        exit;
    }
}

// Soru-Cevap silme işlemi
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $result = $questionAnswerService->deleteQuestionAnswer($id);
    set_session_message($result['status'], $result['message']);
    header("Location: question_answers.php");
    exit;
}

// Filtreleme seçenekleri
$filterSubcategoryId = isset($_GET['filter_subCategoryId']) ? intval($_GET['filter_subCategoryId']) : 0;
$filterPackageId = isset($_GET['filter_packageId']) ? intval($_GET['filter_packageId']) : 0;
$includeNullPackageId = isset($_GET['include_null_packageId']) && $_GET['include_null_packageId'] == 'on';

// Tüm soru-cevapları, alt kategorileri ve soru paketlerini çek
$questionAnswers = $questionAnswerService->getQuestionAnswersByFilters($filterSubcategoryId, $filterPackageId, $includeNullPackageId);
$subcategories = $subcategoryService->getAllSubcategoriesWithCategoryNames();
$questionPackages = $questionAnswerService->getAllQuestionPackages();
$categories = $categoryService->getAllCategories(); // Tüm kategorileri çek

include '_head.php'; // Header'ı dahil et
?>

<h1 class="mb-4">Soru-Cevaplar</h1>
<?php display_session_message(); // Oturum mesajlarını göster ?>

<button type="button" class="btn btn-success mb-3" data-bs-toggle="modal" data-bs-target="#addQAModal">
    Yeni Soru-Cevap Ekle (Tekli)
</button>

<!-- CSV Yükleme Butonu -->
<button type="button" class="btn btn-info mb-3" data-bs-toggle="modal" data-bs-target="#uploadCSVModal">
    <i class="fas fa-file-csv"></i> CSV Yükle
</button>

<!-- Toplu İşlem Butonları -->
<div class="mb-3" id="bulkActions" style="display: none;">
    <button type="button" class="btn btn-danger" id="bulkDeleteBtn">Seçilenleri Sil (<span id="selectedCountDelete">0</span>)</button>
    <button type="button" class="btn btn-primary" id="bulkChangePackageBtn" data-bs-toggle="modal" data-bs-target="#bulkChangePackageModal">Seçilenlerin Paketini Değiştir (<span id="selectedCountPackage">0</span>)</button>
</div>

<!-- Filtreleme Formu -->
<div class="card mb-4">
    <div class="card-header">Filtrele</div>
    <div class="card-body">
        <form action="question_answers.php" method="GET" class="row g-3 align-items-end">
            <div class="col-md-4">
                <label for="filter_subCategoryId" class="form-label">Alt Kategori</label>
                <select class="form-select" id="filter_subCategoryId" name="filter_subCategoryId">
                    <option value="0">Tüm Alt Kategoriler</option>
                    <?php foreach ($subcategories as $subcat): ?>
                        <option value="<?php echo htmlspecialchars($subcat['id']); ?>" <?php echo ($filterSubcategoryId == $subcat['id']) ? 'selected' : ''; ?>><?php echo htmlspecialchars($subcat['category_name']) . ' > ' . htmlspecialchars($subcat['name']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-4">
                <label for="filter_packageId" class="form-label">Soru Paketi</label>
                <select class="form-select" id="filter_packageId" name="filter_packageId">
                    <option value="0">Tüm Soru Paketleri</option>
                    <?php foreach ($questionPackages as $package): ?>
                        <option value="<?php echo htmlspecialchars($package['id']); ?>" <?php echo ($filterPackageId == $package['id']) ? 'selected' : ''; ?>><?php echo htmlspecialchars($package['subcategory_name']) . ' > ' . htmlspecialchars($package['title']); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
             <div class="col-md-2 form-check form-switch d-flex align-items-center mb-0 mt-3">
                <input class="form-check-input" type="checkbox" id="include_null_packageId" name="include_null_packageId" <?php echo ($includeNullPackageId) ? 'checked' : ''; ?>>
                <label class="form-check-label ms-2" for="include_null_packageId">Paketsiz Sorular</label>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-secondary">Filtrele</button>
                <a href="question_answers.php" class="btn btn-outline-secondary">Temizle</a>
            </div>
        </form>
    </div>
</div>

<div class="table-responsive">
    <table class="table table-striped table-hover" id="questionAnswerTable">
        <thead>
            <tr>
                <th><input type="checkbox" id="selectAllCheckbox"></th> <!-- Select All Checkbox -->
                <th>ID</th>
                <th>Alt Kategori</th>
                <th>Soru Paketi</th>
                <th>Soru</th>
                <th>Cevap</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($questionAnswers)): ?>
                <?php foreach ($questionAnswers as $qa): ?>
                    <tr>
                        <td><input type="checkbox" class="rowCheckbox" value="<?php echo htmlspecialchars($qa['id']); ?>"></td> <!-- Row Checkbox -->
                        <td><?php echo htmlspecialchars($qa['id']); ?></td>
                        <td><?php echo htmlspecialchars($qa['subcategory_name']); ?></td>
                        <td><?php echo htmlspecialchars($qa['package_title'] ?? 'Yok'); ?></td>
                        <td><?php echo htmlspecialchars(mb_substr($qa['question'], 0, 100)) . (mb_strlen($qa['question']) > 100 ? '...' : ''); ?></td>
                        <td><?php echo htmlspecialchars(mb_substr($qa['answer'], 0, 100)) . (mb_strlen($qa['answer']) > 100 ? '...' : ''); ?></td>
                        <td>
                            <button type="button" class="btn btn-sm btn-primary edit-btn" 
                                data-id="<?php echo htmlspecialchars($qa['id']); ?>" 
                                data-subcategory-id="<?php echo htmlspecialchars($qa['subCategoryId']); ?>" 
                                data-package-id="<?php echo htmlspecialchars($qa['packageId'] ?? ''); ?>" 
                                data-question="<?php echo htmlspecialchars($qa['question']); ?>" 
                                data-answer="<?php echo htmlspecialchars($qa['answer']); ?>"
                                data-bs-toggle="modal" data-bs-target="#editQAModal">
                                Düzenle
                            </button>
                            <a href="question_answers.php?action=delete&id=<?php echo htmlspecialchars($qa['id']); ?>" 
                                class="btn btn-sm btn-danger" 
                                onclick="return confirm('Bu soru-cevabı silmek istediğinizden emin misiniz? Bu işlem geri alınamaz!');">
                                Sil
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="7" class="text-center">Henüz hiç soru-cevap yok.</td> <!-- colspan 6 yerine 7 oldu checkbox sütunuyla -->
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Yeni Soru-Cevap Ekle Modal -->
<div class="modal fade" id="addQAModal" tabindex="-1" aria-labelledby="addQAModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="addQAModalLabel">Yeni Soru-Cevap Ekle</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <div class="modal-body">
          <input type="hidden" name="action" value="add_qa">
          <div class="mb-3">
            <label for="add_subCategoryId" class="form-label">Alt Kategori Seçin</label>
            <select class="form-select" id="add_subCategoryId" name="subCategoryId" required>
              <option value="">Alt Kategori Seçiniz...</option>
              <?php foreach ($subcategories as $subcat): ?>
                <option value="<?php echo htmlspecialchars($subcat['id']); ?>"><?php echo htmlspecialchars($subcat['category_name']) . ' > ' . htmlspecialchars($subcat['name']); ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-3">
            <label for="add_packageId" class="form-label">Soru Paketi Seçin (İsteğe Bağlı)</label>
            <select class="form-select" id="add_packageId" name="packageId">
              <option value="">Paket Seçiniz...</option>
              <?php foreach ($questionPackages as $package): ?>
                <option value="<?php echo htmlspecialchars($package['id']); ?>"><?php echo htmlspecialchars($package['subcategory_name']) . ' > ' . htmlspecialchars($package['title']); ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-3">
            <label for="add_question" class="form-label">Soru</label>
            <textarea class="form-control" id="add_question" name="question" rows="5" required></textarea>
          </div>
          <div class="mb-3">
            <label for="add_answer" class="form-label">Cevap</label>
            <textarea class="form-control" id="add_answer" name="answer" rows="5" required></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
          <button type="submit" class="btn btn-primary">Soru-Cevap Ekle</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Soru-Cevap Düzenle Modal -->
<div class="modal fade" id="editQAModal" tabindex="-1" aria-labelledby="editQAModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editQAModalLabel">Soru-Cevap Düzenle</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <div class="modal-body">
          <input type="hidden" name="action" value="edit_qa">
          <input type="hidden" name="qa_id" id="edit_qa_id">
          <div class="mb-3">
            <label for="edit_subCategoryId" class="form-label">Alt Kategori Seçin</label>
            <select class="form-select" id="edit_subCategoryId" name="subCategoryId" required>
              <option value="">Alt Kategori Seçiniz...</option>
              <?php foreach ($subcategories as $subcat): ?>
                <option value="<?php echo htmlspecialchars($subcat['id']); ?>"><?php echo htmlspecialchars($subcat['category_name']) . ' > ' . htmlspecialchars($subcat['name']); ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-3">
            <label for="edit_packageId" class="form-label">Soru Paketi Seçin (İsteğe Bağlı)</label>
            <select class="form-select" id="edit_packageId" name="packageId">
              <option value="">Paket Seçiniz...</option>
              <?php foreach ($questionPackages as $package): ?>
                <option value="<?php echo htmlspecialchars($package['id']); ?>"><?php echo htmlspecialchars($package['subcategory_name']) . ' > ' . htmlspecialchars($package['title']); ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-3">
            <label for="edit_question" class="form-label">Soru</label>
            <textarea class="form-control" id="edit_question" name="question" rows="5" required></textarea>
          </div>
          <div class="mb-3">
            <label for="edit_answer" class="form-label">Cevap</label>
            <textarea class="form-control" id="edit_answer" name="answer" rows="5" required></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
          <button type="submit" class="btn btn-primary">Değişiklikleri Kaydet</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- CSV Yükleme Modal -->
<div class="modal fade" id="uploadCSVModal" tabindex="-1" aria-labelledby="uploadCSVModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="uploadCSVModalLabel">CSV ile Toplu Soru Yükle</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <!-- Form, dosyayı işleyecek PHP dosyasına POST edecek -->
      <form action="upload_questions_csv.php" method="post" enctype="multipart/form-data">
        <div class="modal-body">
           <div class="mb-3">
            <label for="upload_categoryId" class="form-label">Ana Kategori Seçin</label>
            <select class="form-select" id="upload_categoryId" name="categoryId" required>
              <option value="">Ana Kategori Seçiniz...</option>
              <?php foreach ($categories as $category): ?>
                <option value="<?php echo htmlspecialchars($category['id']); ?>"><?php echo htmlspecialchars($category['name']); ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-3">
            <label for="upload_subCategoryId" class="form-label">Alt Kategori Seçin</label>
            <select class="form-select" id="upload_subCategoryId" name="subCategoryId" required>
              <option value="">Önce Ana Kategori Seçiniz...</option>
            </select>
          </div>
           <div class="mb-3">
            <label for="upload_packageId" class="form-label">Soru Paketi Seçin (İsteğe Bağlı)</label>
            <select class="form-select" id="upload_packageId" name="packageId">
              <option value="">Paket Seçiniz (Paketsiz sorular için boş bırakın)...</option>
            </select>
          </div>
          <div class="mb-3">
            <label for="csvFile" class="form-label">Yüklenecek CSV Dosyasını Seçin</label>
            <input class="form-control" type="file" id="csvFile" name="csvFile" accept=".csv" required>
            <small class="form-text text-muted">Lütfen başlık satırı içeren, virgülle ayrılmış (.csv) dosya formatını kullanın. Gerekli sütunlar: Soru, Cevap.</small>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
          <button type="submit" class="btn btn-primary">Yükle</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Çoklu Soru Ekle Form Alanı -->
<div class="card mt-4">
    <div class="card-header">
        Çoklu Soru-Cevap Ekle
    </div>
    <div class="card-body">
        <form id="multipleQuestionsForm" action="add_multiple_questions.php" method="post">
             <div class="mb-3">
                <label for="multiple_categoryId" class="form-label">Ana Kategori Seçin</label>
                <select class="form-select" id="multiple_categoryId" name="categoryId" required>
                  <option value="">Ana Kategori Seçiniz...</option>
                  <?php foreach ($categories as $category): ?>
                    <option value="<?php echo htmlspecialchars($category['id']); ?>"><?php echo htmlspecialchars($category['name']); ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
             <div class="mb-3">
                <label for="multiple_subCategoryId" class="form-label">Alt Kategori Seçin</label>
                <select class="form-select" id="multiple_subCategoryId" name="subCategoryId" required>
                  <option value="">Önce Ana Kategori Seçiniz...</option>
                </select>
              </div>
              <div class="mb-3">
                <label for="multiple_packageId" class="form-label">Soru Paketi Seçin (İsteğe Bağlı)</label>
                <select class="form-select" id="multiple_packageId" name="packageId">
                  <option value="">Paket Seçiniz...</option>
                </select>
              </div>

            <hr>

            <div id="questionsContainer">
                <!-- Dinamik olarak eklenecek soru-cevap çiftleri buraya gelecek -->
                 <div class="question-pair mb-4 p-3 border rounded">
                    <button type="button" class="btn-close float-end remove-question" aria-label="Kapat"></button>
                    <div class="mb-3">
                        <label for="question_1" class="form-label">Soru 1</label>
                        <textarea class="form-control" id="question_1" name="questions[1][question]" rows="3" required></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="answer_1" class="form-label">Cevap 1</label>
                        <textarea class="form-control" id="answer_1" name="questions[1][answer]" rows="3" required></textarea>
                    </div>
                 </div>
            </div>

            <button type="button" class="btn btn-secondary mb-3" id="addQuestionPair">Yeni Soru Ekle</button>

            <div class="d-grid">
                 <button type="submit" class="btn btn-primary">Tümünü Kaydet</button>
            </div>
        </form>
    </div>
</div>


<script>
    document.addEventListener('DOMContentLoaded', function () {
        var editQAModal = document.getElementById('editQAModal');
        editQAModal.addEventListener('show.bs.modal', function (event) {
            var button = event.relatedTarget;
            var id = button.getAttribute('data-id');
            var subCategoryId = button.getAttribute('data-subcategory-id');
            var packageId = button.getAttribute('data-package-id');
            var question = button.getAttribute('data-question');
            var answer = button.getAttribute('data-answer');

            var modalIdInput = editQAModal.querySelector('#edit_qa_id');
            var modalSubCategoryIdSelect = editQAModal.querySelector('#edit_subCategoryId');
            var modalPackageIdSelect = editQAModal.querySelector('#edit_packageId');
            var modalQuestionTextarea = editQAModal.querySelector('#edit_question');
            var modalAnswerTextarea = editQAModal.querySelector('#edit_answer');

            modalIdInput.value = id;
            modalSubCategoryIdSelect.value = subCategoryId;
            modalPackageIdSelect.value = packageId; 
            modalQuestionTextarea.value = question;
            modalAnswerTextarea.value = answer;

            // Modal açıldığında seçili alt kategoriye göre paketleri yükle ve mevcut paketi seçili tut
            fetchPackages(subCategoryId, modalPackageIdSelect, packageId);
        });

        // Çoklu Soru Ekleme Formu Dinamik Alanları
        const questionsContainer = document.getElementById('questionsContainer');
        const addQuestionPairButton = document.getElementById('addQuestionPair');
        let questionCounter = questionsContainer.querySelectorAll('.question-pair').length; // Mevcut çift sayısını al

        function addQuestionPair() {
            questionCounter++;
            const newPairHtml = `
                 <div class="question-pair mb-4 p-3 border rounded">
                    <button type="button" class="btn-close float-end remove-question" aria-label="Kapat"></button>
                    <div class="mb-3">
                        <label for="question_${questionCounter}" class="form-label">Soru ${questionCounter}</label>
                        <textarea class="form-control" id="question_${questionCounter}" name="questions[${questionCounter}][question]" rows="3" required></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="answer_${questionCounter}" class="form-label">Cevap ${questionCounter}</label>
                        <textarea class="form-control" id="answer_${questionCounter}" name="questions[${questionCounter}][answer]" rows="3" required></textarea>
                    </div>
                 </div>
            `;
            questionsContainer.insertAdjacentHTML('beforeend', newPairHtml);
            // Yeni eklenen textarea'ların boyutlandırılması için TinyMCE veya benzeri bir editör kullanılıyorsa burada başlatılması gerekir.
            // Şu an TinyMCE tekli modalda kullanılıyor, çoklu form için ayrıca değerlendirilebilir.
        }

        function removeQuestionPair(event) {
            if (event.target.classList.contains('remove-question')) {
                // İlk soru çiftinin silinmesini engelle
                if (questionsContainer.querySelectorAll('.question-pair').length > 1) {
                     event.target.closest('.question-pair').remove();
                     // Soru numaralarını güncelle (isteğe bağlı, karmaşıklığı artırabilir)
                     updateQuestionNumbers();
                }
            }
        }

        function updateQuestionNumbers() {
             questionsContainer.querySelectorAll('.question-pair').forEach((pair, index) => {
                 const number = index + 1;
                 pair.querySelector('.form-label[for^="question_"]').textContent = `Soru ${number}`;
                 pair.querySelector('textarea[name$="[question]"]').id = `question_${number}`;
                 pair.querySelector('textarea[name$="[question]"]').name = `questions[${number}][question]`;

                 pair.querySelector('.form-label[for^="answer_"]').textContent = `Cevap ${number}`;
                 pair.querySelector('textarea[name$="[answer]"]').id = `answer_${number}`;
                 pair.querySelector('textarea[name$="[answer]"]').name = `questions[${number}][answer]`;
             });
             questionCounter = questionsContainer.querySelectorAll('.question-pair').length;
        }

        addQuestionPairButton.addEventListener('click', addQuestionPair);
        questionsContainer.addEventListener('click', removeQuestionPair);

        // Sayfa yüklendiğinde en az bir soru çifti olduğundan emin ol (HTML içinde bir tane var)
        // if (questionCounter === 0) {
        //     addQuestionPair();
        // }

        // DataTable Checkbox ve Toplu İşlemler
        const selectAllCheckbox = document.getElementById('selectAllCheckbox');
        const rowCheckboxes = document.querySelectorAll('.rowCheckbox');
        const bulkActionsDiv = document.getElementById('bulkActions');
        const bulkDeleteBtn = document.getElementById('bulkDeleteBtn');
        const bulkChangePackageBtn = document.getElementById('bulkChangePackageBtn');
        const selectedCountDeleteSpan = document.getElementById('selectedCountDelete');
        const selectedCountPackageSpan = document.getElementById('selectedCountPackage');
        
        function updateBulkActionsVisibility() {
            const checkedCheckboxes = document.querySelectorAll('.rowCheckbox:checked');
            const count = checkedCheckboxes.length;

            if (count > 0) {
                bulkActionsDiv.style.display = 'block';
                selectedCountDeleteSpan.textContent = count;
                selectedCountPackageSpan.textContent = count;
            } else {
                bulkActionsDiv.style.display = 'none';
            }
        }

        selectAllCheckbox.addEventListener('change', function() {
            rowCheckboxes.forEach(checkbox => {
                checkbox.checked = selectAllCheckbox.checked;
            });
            updateBulkActionsVisibility();
        });

        rowCheckboxes.forEach(checkbox => {
            checkbox.addEventListener('change', function() {
                // Eğer tüm row checkboxları işaretliyse selectAll checkbox'ı da işaretle
                const allChecked = Array.from(rowCheckboxes).every(cb => cb.checked);
                selectAllCheckbox.checked = allChecked;
                updateBulkActionsVisibility();
            });
        });

        // Toplu Silme İşlemi
        bulkDeleteBtn.addEventListener('click', function() {
            const checkedCheckboxes = document.querySelectorAll('.rowCheckbox:checked');
            const selectedIds = Array.from(checkedCheckboxes).map(cb => cb.value);

            if (selectedIds.length > 0 && confirm('Seçilen ' + selectedIds.length + ' soru-cevabı silmek istediğinizden emin misiniz? Bu işlem geri alınamaz!')) {
                // Form oluştur ve POST ile gönder
                const form = document.createElement('form');
                form.method = 'POST';
                form.action = 'bulk_actions_questions.php'; // Yeni oluşturulacak dosya

                const actionInput = document.createElement('input');
                actionInput.type = 'hidden';
                actionInput.name = 'action';
                actionInput.value = 'bulk_delete';
                form.appendChild(actionInput);

                selectedIds.forEach(id => {
                    const idInput = document.createElement('input');
                    idInput.type = 'hidden';
                    idInput.name = 'selected_ids[]';
                    idInput.value = id;
                    form.appendChild(idInput);
                });

                document.body.appendChild(form);
                form.submit();
            }
        });

        // Toplu Paket Değiştirme Modalını Doldur
        const bulkChangePackageModal = document.getElementById('bulkChangePackageModal');
        bulkChangePackageModal.addEventListener('show.bs.modal', function() {
             // Paket seçenekleri zaten PHP tarafından dolduruluyor.
             // Sadece hidden inputa seçilen ID'leri ekleyeceğiz.
             const checkedCheckboxes = document.querySelectorAll('.rowCheckbox:checked');
             const selectedIds = Array.from(checkedCheckboxes).map(cb => cb.value);

             const modalBody = bulkChangePackageModal.querySelector('.modal-body');
             // Önceki hidden inputları temizle
             modalBody.querySelectorAll('input[name="selected_ids[]"]').forEach(input => input.remove());

             // Yeni hidden inputları ekle
             selectedIds.forEach(id => {
                 const idInput = document.createElement('input');
                 idInput.type = 'hidden';
                 idInput.name = 'selected_ids[]';
                 idInput.value = id;
                 modalBody.appendChild(idInput);
             });
        });

        // Yeni Soru-Cevap Ekle Modalındaki Alt Kategoriye Göre Paketleri Filtreleme
        const addSubcategoryIdSelect = document.getElementById('add_subCategoryId');
        const addPackageIdSelect = document.getElementById('add_packageId');

        addSubcategoryIdSelect.addEventListener('change', function() {
            const subCategoryId = this.value;
            fetchPackages(subCategoryId, addPackageIdSelect);
        });

        // Düzenle Modalındaki Alt Kategoriye Göre Paketleri Filtreleme (mevcut data-package-id değerini koruyarak)
        const editSubcategoryIdSelect = document.getElementById('edit_subCategoryId');
        const editPackageIdSelect = document.getElementById('edit_packageId');

        editSubcategoryIdSelect.addEventListener('change', function() {
            const subCategoryId = this.value;
            fetchPackages(subCategoryId, editPackageIdSelect);
        });

        // Paketleri çeken ve dolduran fonksiyon
        function fetchPackages(subCategoryId, packageSelectElement, selectedPackageId = null) {
            packageSelectElement.innerHTML = '<option value="">Paket Seçiniz...</option>'; // Önceki seçenekleri temizle

            if (subCategoryId) {
                fetch(`get_question_packages_by_subcategory.php?subCategoryId=${subCategoryId}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 'success') {
                            data.packages.forEach(packageItem => {
                                const option = document.createElement('option');
                                option.value = packageItem.id;
                                option.textContent = `${packageItem.subcategory_name} > ${packageItem.title}`;
                                if (selectedPackageId && packageItem.id == selectedPackageId) {
                                    option.selected = true;
                                }
                                packageSelectElement.appendChild(option);
                            });
                        } else {
                            console.error('Paketler yüklenirken hata oluştu:', data.message);
                        }
                    })
                    .catch(error => console.error('AJAX hatası:', error));
            }
        }

        // CSV Yükleme Modalındaki Dinamik Dropdownlar için JS
        const uploadCategoryIdSelect = document.getElementById('upload_categoryId');
        const uploadSubcategoryIdSelect = document.getElementById('upload_subCategoryId');
        const uploadPackageIdSelect = document.getElementById('upload_packageId');

        // Kategori seçimi değiştiğinde alt kategorileri yükle
        uploadCategoryIdSelect.addEventListener('change', function() {
            const categoryId = this.value;
            uploadSubcategoryIdSelect.innerHTML = '<option value="">Alt Kategori Seçiniz...</option>'; // Alt kategorileri temizle
            uploadPackageIdSelect.innerHTML = '<option value="">Paket Seçiniz (Paketsiz sorular için boş bırakın)...</option>'; // Paketleri temizle

            if (categoryId) {
                fetch(`get_subcategories_by_category.php?categoryId=${categoryId}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 'success') {
                            data.subcategories.forEach(subcat => {
                                const option = document.createElement('option');
                                option.value = subcat.id;
                                option.textContent = `${subcat.name}`;
                                uploadSubcategoryIdSelect.appendChild(option);
                            });
                        } else {
                            console.error('Alt kategoriler yüklenirken hata oluştu:', data.message);
                        }
                    })
                    .catch(error => console.error('AJAX hatası:', error));
            }
        });

        // Alt kategori seçimi değiştiğinde paketleri yükle (upload modalı için)
        uploadSubcategoryIdSelect.addEventListener('change', function() {
            const subCategoryId = this.value;
            fetchPackages(subCategoryId, uploadPackageIdSelect); // Var olan fetchPackages fonksiyonunu kullan
        });
        
        // Çoklu Soru Ekleme Formundaki Dinamik Dropdownlar için JS
        const multipleCategoryIdSelect = document.getElementById('multiple_categoryId');
        const multipleSubcategoryIdSelect = document.getElementById('multiple_subCategoryId');
        const multiplePackageIdSelect = document.getElementById('multiple_packageId');

        // Kategori seçimi değiştiğinde alt kategorileri yükle
        multipleCategoryIdSelect.addEventListener('change', function() {
            const categoryId = this.value;
            multipleSubcategoryIdSelect.innerHTML = '<option value="">Alt Kategori Seçiniz...</option>'; // Alt kategorileri temizle
            multiplePackageIdSelect.innerHTML = '<option value="">Paket Seçiniz...</option>'; // Paketleri temizle

            if (categoryId) {
                fetch(`get_subcategories_by_category.php?categoryId=${categoryId}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === 'success') {
                            data.subcategories.forEach(subcat => {
                                const option = document.createElement('option');
                                option.value = subcat.id;
                                option.textContent = `${subcat.name}`;
                                multipleSubcategoryIdSelect.appendChild(option);
                            });
                        } else {
                            console.error('Alt kategoriler yüklenirken hata oluştu:', data.message);
                        }
                    })
                    .catch(error => console.error('AJAX hatası:', error));
            }
        });

        // Alt kategori seçimi değiştiğinde paketleri yükle (çoklu form için)
        multipleSubcategoryIdSelect.addEventListener('change', function() {
            const subCategoryId = this.value;
            fetchPackages(subCategoryId, multiplePackageIdSelect); // Var olan fetchPackages fonksiyonunu kullan
        });
        
        // Sayfa yüklendiğinde ilk kontrolü yap
        updateBulkActionsVisibility();

    });
</script>

<!-- Toplu Paket Değiştir Modal -->
<div class="modal fade" id="bulkChangePackageModal" tabindex="-1" aria-labelledby="bulkChangePackageModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="bulkChangePackageModalLabel">Seçilenlerin Paketini Değiştir</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <!-- Form, toplu işlem dosyasını hedef alacak -->
      <form action="bulk_actions_questions.php" method="post">
        <div class="modal-body">
          <input type="hidden" name="action" value="bulk_change_package">
          <!-- selected_ids hidden inputları JS tarafından eklenecek -->
          
          <div class="mb-3">
            <label for="bulk_packageId" class="form-label">Yeni Soru Paketi Seçin (Boş Bırakmak İçin İlk Seçeneği Seçin)</label>
            <select class="form-select" id="bulk_packageId" name="packageId">
              <option value="">Paket Seçiniz (Paketsiz Yap)</option>
              <?php foreach ($questionPackages as $package): ?>
                <option value="<?php echo htmlspecialchars($package['id']); ?>"><?php echo htmlspecialchars($package['subcategory_name']) . ' > ' . htmlspecialchars($package['title']); ?></option>
              <?php endforeach; ?>
            </select>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
          <button type="submit" class="btn btn-primary">Değişiklikleri Uygula</button>
        </div>
      </form>
    </div>
  </div>
</div>

<?php include '_footer.php'; // Footer'ı dahil et ?> 