<?php
require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/UserService.php';
require_once __DIR__ . '/../helpers/session_helper.php';

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Eğer zaten giriş yapılmışsa, index sayfasına yönlendir
if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
    header("Location: index.php");
    exit;
}

$userService = new UserService($conn);

$username = $password = "";
$username_err = $password_err = "";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Kullanıcı adını doğrula
    if (empty(trim($_POST["username"]))) {
        $username_err = "Lütfen kullanıcı adınızı girin.";
    } else {
        $username = trim($_POST["username"]);
    }

    // Şifreyi doğrula
    if (empty(trim($_POST["password"]))) {
        $password_err = "Lütfen şifrenizi girin.";
    } else {
        $password = trim($_POST["password"]);
    }

    // Doğrulama hatası yoksa giriş yapmayı dene
    if (empty($username_err) && empty($password_err)) {
        $loginResult = $userService->loginUser($username, $password);

        if ($loginResult['status'] === 'success') {
            // Oturum değişkenlerini ayarla
            $_SESSION['loggedin'] = true;
            $_SESSION['id'] = $loginResult['user_id'];
            $_SESSION['username'] = $loginResult['username'];

            set_session_message('success', $loginResult['message']);
            header("Location: index.php");
            exit;
        } else {
            set_session_message('error', $loginResult['message']);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AGS Admin Giriş</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <style>
        body {
            display: flex;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            background-color: #f8f9fa;
        }
        .login-container {
            width: 100%;
            max-width: 400px;
            padding: 15px;
            margin: auto;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h2 class="text-center mb-4">AGS Admin Giriş</h2>
        <?php display_session_message(); // Oturum mesajlarını göster ?>
        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
            <div class="mb-3">
                <label for="username" class="form-label">Kullanıcı Adı</label>
                <input type="text" name="username" id="username" class="form-control <?php echo (!empty($username_err)) ? 'is-invalid' : ''; ?>" value="<?php echo htmlspecialchars($username); ?>">
                <span class="invalid-feedback"><?php echo $username_err; ?></span>
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">Şifre</label>
                <input type="password" name="password" id="password" class="form-control <?php echo (!empty($password_err)) ? 'is-invalid' : ''; ?>">
                <span class="invalid-feedback"><?php echo $password_err; ?></span>
            </div>
            <div class="d-grid">
                <button type="submit" class="btn btn-primary">Giriş Yap</button>
            </div>
        </form>
    </div>

    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html> 