<?php
require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/QuestionAnswerService.php';

header('Content-Type: application/json');

$response = ['status' => 'error', 'message' => 'Geçersiz istek.'];

if (isset($_GET['subCategoryId'])) {
    $subCategoryId = intval($_GET['subCategoryId']);
    $questionAnswerService = new QuestionAnswerService($conn);
    
    if ($subCategoryId > 0) {
        $packages = $questionAnswerService->getQuestionPackagesBySubcategoryId($subCategoryId);
        $response = ['status' => 'success', 'packages' => $packages];
    } else {
        // Eğer subCategoryId 0 ise (Tüm Alt Kategoriler seçeneği gibi), tüm paketleri döndürebiliriz
        // Veya sadece boş bir liste döndürebiliriz, şu an boş liste döndürüyorum.
        $packages = $questionAnswerService->getAllQuestionPackages(); // Eğer 0 ise tüm paketleri getirsin
        $response = ['status' => 'success', 'packages' => $packages];
    }
}

echo json_encode($response);
?> 