<?php
require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/CategoryService.php';
require_once __DIR__ . '/../helpers/session_helper.php';

check_admin_session(); // Admin oturumunu kontrol et

$categoryService = new CategoryService($conn);

// Kategori ekleme veya güncelleme işlemleri
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['action']) && $_POST['action'] == 'add_category') {
        $name = trim($_POST['name']);
        $description = trim($_POST['description']);
        
        if (empty($name)) {
            set_session_message('error', "Kategori adı boş bırakılamaz.");
        } else {
            $result = $categoryService->addCategory($name, $description);
            set_session_message($result['status'], $result['message']);
        }
    } elseif (isset($_POST['action']) && $_POST['action'] == 'edit_category') {
        $id = intval($_POST['category_id']);
        $name = trim($_POST['name']);
        $description = trim($_POST['description']);

        if (empty($name)) {
            set_session_message('error', "Kategori adı boş bırakılamaz.");
        } else {
            $result = $categoryService->updateCategory($id, $name, $description);
            set_session_message($result['status'], $result['message']);
        }
    }
    header("Location: categories.php"); // POST işlemi sonrası sayfayı yenile
    exit;
}

// Kategori silme işlemi
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $result = $categoryService->deleteCategory($id);
    set_session_message($result['status'], $result['message']);
    header("Location: categories.php");
    exit;
}

// Tüm kategorileri çek
$categories = $categoryService->getAllCategories();

include '_head.php'; // Header'ı dahil et
?>

<h1 class="mb-4">Kategoriler</h1>
<?php display_session_message(); // Oturum mesajlarını göster ?>

<button type="button" class="btn btn-success mb-3" data-bs-toggle="modal" data-bs-target="#addCategoryModal">
    Yeni Kategori Ekle
</button>

<div class="table-responsive">
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th>ID</th>
                <th>Ad</th>
                <th>Açıklama</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($categories)): ?>
                <?php foreach ($categories as $category): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($category['id']); ?></td>
                        <td><?php echo htmlspecialchars($category['name']); ?></td>
                        <td><?php echo htmlspecialchars($category['description']); ?></td>
                        <td>
                            <button type="button" class="btn btn-sm btn-primary edit-btn" 
                                data-id="<?php echo htmlspecialchars($category['id']); ?>" 
                                data-name="<?php echo htmlspecialchars($category['name']); ?>" 
                                data-description="<?php echo htmlspecialchars($category['description']); ?>"
                                data-bs-toggle="modal" data-bs-target="#editCategoryModal">
                                Düzenle
                            </button>
                            <a href="categories.php?action=delete&id=<?php echo htmlspecialchars($category['id']); ?>" 
                                class="btn btn-sm btn-danger" 
                                onclick="return confirm('Bu kategoriyi silmek istediğinizden emin misiniz? Bu işlem geri alınamaz!');">
                                Sil
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="4" class="text-center">Henüz hiç kategori yok.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Yeni Kategori Ekle Modal -->
<div class="modal fade" id="addCategoryModal" tabindex="-1" aria-labelledby="addCategoryModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="addCategoryModalLabel">Yeni Kategori Ekle</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <div class="modal-body">
          <input type="hidden" name="action" value="add_category">
          <div class="mb-3">
            <label for="add_name" class="form-label">Kategori Adı</label>
            <input type="text" class="form-control" id="add_name" name="name" required>
          </div>
          <div class="mb-3">
            <label for="add_description" class="form-label">Açıklama (İsteğe Bağlı)</label>
            <textarea class="form-control" id="add_description" name="description" rows="3"></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
          <button type="submit" class="btn btn-primary">Kategori Ekle</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Kategori Düzenle Modal -->
<div class="modal fade" id="editCategoryModal" tabindex="-1" aria-labelledby="editCategoryModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editCategoryModalLabel">Kategori Düzenle</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <div class="modal-body">
          <input type="hidden" name="action" value="edit_category">
          <input type="hidden" name="category_id" id="edit_category_id">
          <div class="mb-3">
            <label for="edit_name" class="form-label">Kategori Adı</label>
            <input type="text" class="form-control" id="edit_name" name="name" required>
          </div>
          <div class="mb-3">
            <label for="edit_description" class="form-label">Açıklama (İsteğe Bağlı)</label>
            <textarea class="form-control" id="edit_description" name="description" rows="3"></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
          <button type="submit" class="btn btn-primary">Değişiklikleri Kaydet</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        var editCategoryModal = document.getElementById('editCategoryModal');
        editCategoryModal.addEventListener('show.bs.modal', function (event) {
            // Tetikleyen butonu al
            var button = event.relatedTarget;

            // Data özelliklerinden bilgileri çek
            var id = button.getAttribute('data-id');
            var name = button.getAttribute('data-name');
            var description = button.getAttribute('data-description');

            // Modaldaki input alanlarını doldur
            var modalIdInput = editCategoryModal.querySelector('#edit_category_id');
            var modalNameInput = editCategoryModal.querySelector('#edit_name');
            var modalDescriptionInput = editCategoryModal.querySelector('#edit_description');

            modalIdInput.value = id;
            modalNameInput.value = name;
            modalDescriptionInput.value = description;
        });
    });
</script>

<?php include '_footer.php'; // Footer'ı dahil et ?> 