<?php
require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/QuestionAnswerService.php';
require_once __DIR__ . '/../helpers/session_helper.php';

check_admin_session();

$questionAnswerService = new QuestionAnswerService($conn);

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action']) && isset($_POST['selected_ids']) && is_array($_POST['selected_ids'])) {
    $action = $_POST['action'];
    $selectedIds = array_map('intval', $_POST['selected_ids']);

    if (empty($selectedIds)) {
        set_session_message('warning', "Toplu işlem için herhangi bir öğe seçilmedi.");
    } else {
        switch ($action) {
            case 'bulk_delete':
                $result = $questionAnswerService->deleteMultipleQuestionAnswers($selectedIds);
                set_session_message($result['status'], $result['message']);
                break;

            case 'bulk_change_package':
                $packageId = isset($_POST['packageId']) && $_POST['packageId'] !== '' ? intval($_POST['packageId']) : NULL;
                $result = $questionAnswerService->updateMultipleQuestionAnswerPackage($selectedIds, $packageId);
                set_session_message($result['status'], $result['message']);
                break;

            default:
                set_session_message('error', "Geçersiz toplu işlem türü.");
                break;
        }
    }

} else {
    set_session_message('error', "Geçersiz istek metodu veya eksik veri.");
}

// İşlem sonrası question_answers.php sayfasına yönlendir
header("Location: question_answers.php");
exit;
?> 