<?php
require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/QuestionAnswerService.php';
require_once __DIR__ . '/../helpers/session_helper.php';

check_admin_session();

$questionAnswerService = new QuestionAnswerService($conn);

$success_count = 0;
$error_count = 0;
$error_details = [];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $subCategoryId = isset($_POST['subCategoryId']) ? intval($_POST['subCategoryId']) : 0;
    $packageId = isset($_POST['packageId']) && $_POST['packageId'] !== '' ? intval($_POST['packageId']) : NULL;
    $questions = isset($_POST['questions']) ? $_POST['questions'] : [];

    if ($subCategoryId <= 0) {
        set_session_message('error', "Çoklu soru eklemek için bir Alt Kategori seçimi yapmalısınız.");
        header("Location: question_answers.php");
        exit;
    }

    if (!empty($questions)) {
        foreach ($questions as $key => $qa_pair) {
            $question = trim($qa_pair['question'] ?? '');
            $answer = trim($qa_pair['answer'] ?? '');

            // Soru veya cevap boşsa atla
            if (empty($question) || empty($answer)) {
                // Opsiyonel: Hata detaylarına boş alan bilgisini ekleyebiliriz
                // $error_details[] = "Soru #{$key}: Soru veya cevap boş bırakılamaz.";
                continue; // Boş olanları eklememesi için döngünün bu adımını atla
            }

            // QuestionAnswerService'in addQuestionAnswer metodu sadece soru, cevap, subCategoryId ve packageId alacak şekilde ayarlanmalı.
            // Şık alanları (option_a, ... option_e, answer_key) service metodu içinde boş veya varsayılan değerlerle kaydedilebilir.
            $result = $questionAnswerService->addQuestionAnswer($subCategoryId, $packageId, $question, $answer);

            if ($result['status'] == 'success') {
                $success_count++;
            } else {
                $error_count++;
                $error_details[] = "Soru: \"" . htmlspecialchars(mb_substr($question, 0, 50)) . "...\" için hata: " . $result['message'];
            }
        }
    } else {
         set_session_message('error', "Gönderilen formda hiç soru-cevap çifti bulunamadı.");
         header("Location: question_answers.php");
         exit;
    }

    // İşlem özeti mesajı oluştur
    $summary_message = "Toplu Soru Ekleme Tamamlandı: Başarılı: {$success_count}, Hatalı: {$error_count}.";
    if (!empty($error_details)) {
        $summary_message .= " Hata detayları: " . implode("; ", $error_details);
    }

    set_session_message($error_count > 0 ? 'warning' : 'success', $summary_message);

} else {
    // POST isteği değilse ana sayfaya yönlendir
    set_session_message('error', "Geçersiz istek metodu.");
}

// İşlem sonrası question_answers.php sayfasına yönlendir
header("Location: question_answers.php");
exit;
?> 