<?php

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

function set_session_message($type, $message) {
    $_SESSION['message'] = [
        'type' => $type,
        'content' => $message
    ];
}

function get_session_message() {
    if (isset($_SESSION['message'])) {
        $message = $_SESSION['message'];
        unset($_SESSION['message']); // Mesajı bir kez gösterdikten sonra sil
        return $message;
    }
    return null;
}

function display_session_message() {
    $message = get_session_message();
    if ($message) {
        $alert_class = '';
        switch ($message['type']) {
            case 'success':
                $alert_class = 'alert-success';
                break;
            case 'error':
                $alert_class = 'alert-danger';
                break;
            case 'warning':
                $alert_class = 'alert-warning';
                break;
            case 'info':
                $alert_class = 'alert-info';
                break;
            default:
                $alert_class = 'alert-secondary';
        }
        echo '<div class="alert ' . $alert_class . ' alert-dismissible fade show" role="alert">';
        echo htmlspecialchars($message['content']);
        echo '  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>';
        echo '</div>';
    }
}

// Oturum kontrolü için fonksiyon
function check_admin_session() {
    if (session_status() == PHP_SESSION_NONE) {
        session_start();
    }
    if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
        header("Location: login.php");
        exit;
    }
}

?> 