<?php

require_once __DIR__ . '/db_connect.php'; // Veritabanı bağlantısını dahil et

// Hata raporlamayı etkinleştir
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "Veritabanı kurulumu başlatılıyor...
";

// 1. users tablosunu oluştur
$sql_create_users_table = "
CREATE TABLE IF NOT EXISTS users (
    id INT(6) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(30) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    reg_date TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";

if ($conn->query($sql_create_users_table) === TRUE) {
    echo "users tablosu başarıyla oluşturuldu veya zaten mevcut.
";
} else {
    echo "users tablosu oluşturulurken hata: " . $conn->error . "
";
}

// Varsayılan admin kullanıcısını ekle (sadece tablo boşsa)
$sql_check_admin = "SELECT COUNT(*) FROM users WHERE username = 'admin'";
$result_check_admin = $conn->query($sql_check_admin);

if ($result_check_admin) {
    $row_check_admin = $result_check_admin->fetch_row();
    if ($row_check_admin[0] == 0) {
        $admin_username = 'admin';
        // Şifre güvenli bir şekilde hash'leniyor.
        $admin_password = password_hash('admin123', PASSWORD_DEFAULT);
        
        $stmt_insert_admin = $conn->prepare("INSERT INTO users (username, password) VALUES (?, ?)");
        $stmt_insert_admin->bind_param("ss", $admin_username, $admin_password);
        if ($stmt_insert_admin->execute()) {
            echo "Varsayılan admin kullanıcısı 'admin' (şifre: admin123) başarıyla eklendi.
";
        } else {
            echo "Varsayılan admin kullanıcısı eklenirken hata: " . $stmt_insert_admin->error . "
";
        }
        $stmt_insert_admin->close();
    } else {
        echo "Admin kullanıcısı 'admin' zaten mevcut.
";
    }
    $result_check_admin->close();
} else {
    echo "Admin kullanıcısı kontrol edilirken hata: " . $conn->error . "
";
}

// 2. categories tablosunu oluştur
$sql_create_categories_table = "
CREATE TABLE IF NOT EXISTS categories (
    id INT(6) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL UNIQUE,
    description TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";

if ($conn->query($sql_create_categories_table) === TRUE) {
    echo "categories tablosu başarıyla oluşturuldu veya zaten mevcut.
";
} else {
    echo "categories tablosu oluşturulurken hata: " . $conn->error . "
";
}

// 3. subcategories tablosunu oluştur
$sql_create_subcategories_table = "
CREATE TABLE IF NOT EXISTS subcategories (
    id INT(6) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    categoryId INT(6) UNSIGNED NOT NULL,
    name VARCHAR(255) NOT NULL,
    description TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (categoryId) REFERENCES categories(id) ON DELETE CASCADE,
    UNIQUE (categoryId, name)
) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";

if ($conn->query($sql_create_subcategories_table) === TRUE) {
    echo "subcategories tablosu başarıyla oluşturuldu veya zaten mevcut.
";
} else {
    echo "subcategories tablosu oluşturulurken hata: " . $conn->error . "
";
}

// 4. question_packages tablosunu oluştur
$sql_create_question_packages_table = "
CREATE TABLE IF NOT EXISTS question_packages (
    id INT(6) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    subCategoryId INT(6) UNSIGNED NOT NULL,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (subCategoryId) REFERENCES subcategories(id) ON DELETE CASCADE,
    UNIQUE (subCategoryId, title)
) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";

if ($conn->query($sql_create_question_packages_table) === TRUE) {
    echo "question_packages tablosu başarıyla oluşturuldu veya zaten mevcut.
";
} else {
    echo "question_packages tablosu oluşturulurken hata: " . $conn->error . "
";
}

// 5. question_answers tablosunu oluştur
$sql_create_question_answers_table = "
CREATE TABLE IF NOT EXISTS question_answers (
    id INT(6) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    subCategoryId INT(6) UNSIGNED NOT NULL,
    packageId INT(6) UNSIGNED NULL,
    question TEXT NOT NULL,
    answer TEXT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (subCategoryId) REFERENCES subcategories(id) ON DELETE CASCADE,
    FOREIGN KEY (packageId) REFERENCES question_packages(id) ON DELETE SET NULL,
    UNIQUE (subCategoryId, question, packageId)
) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";

if ($conn->query($sql_create_question_answers_table) === TRUE) {
    echo "question_answers tablosu başarıyla oluşturuldu veya zaten mevcut.
";
} else {
    echo "question_answers tablosu oluşturulurken hata: " . $conn->error . "
";
}

// 6. fcm_tokens tablosunu oluştur (Bildirim tokenları için)
$sql_create_fcm_tokens_table = "
CREATE TABLE IF NOT EXISTS fcm_tokens (
    id INT(6) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    fcm_token VARCHAR(255) NOT NULL UNIQUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci";

if ($conn->query($sql_create_fcm_tokens_table) === TRUE) {
    echo "fcm_tokens tablosu başarıyla oluşturuldu veya zaten mevcut.\n";
} else {
    echo "fcm_tokens tablosu oluşturulurken hata: " . $conn->error . "\n";
}

echo "Veritabanı kurulumu tamamlandı.\n";

$conn->close();

?> 