<?php
require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/SubcategoryService.php';
require_once __DIR__ . '/../config.php'; // API_KEY için

header('Content-Type: application/json; charset=UTF-8');

$subcategoryService = new SubcategoryService($conn);

$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        if (isset($_GET['id'])) {
            $id = intval($_GET['id']);
            $subcategory = $subcategoryService->getSubcategoryById($id);
            if ($subcategory) {
                echo json_encode(['status' => 'success', 'data' => $subcategory]);
            } else {
                http_response_code(404);
                echo json_encode(['status' => 'error', 'message' => 'Alt kategori bulunamadı.']);
            }
        } elseif (isset($_GET['categoryId'])) {
            $categoryId = intval($_GET['categoryId']);
            $subcategories = $subcategoryService->getSubcategoriesByCategoryId($categoryId);
            echo json_encode(['status' => 'success', 'data' => $subcategories]);
        } else {
            $subcategories = $subcategoryService->getAllSubcategoriesWithCategoryNames();
            echo json_encode(['status' => 'success', 'data' => $subcategories]);
        }
        break;
    
    default:
        http_response_code(405);
        echo json_encode(['status' => 'error', 'message' => 'Desteklenmeyen istek metodu.']);
        break;
}

$conn->close();
?> 