<?php
require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/QuestionAnswerService.php';
require_once __DIR__ . '/../config.php'; // API_KEY için

header('Content-Type: application/json; charset=UTF-8');

$questionAnswerService = new QuestionAnswerService($conn);

$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        if (isset($_GET['id'])) {
            $id = intval($_GET['id']);
            $package = $questionAnswerService->getQuestionPackageById($id);
            if ($package) {
                echo json_encode(['status' => 'success', 'data' => $package]);
            } else {
                http_response_code(404);
                echo json_encode(['status' => 'error', 'message' => 'Soru paketi bulunamadı.']);
            }
        } else {
            $packages = $questionAnswerService->getAllQuestionPackages();
            echo json_encode(['status' => 'success', 'data' => $packages]);
        }
        break;
    
    default:
        http_response_code(405);
        echo json_encode(['status' => 'error', 'message' => 'Desteklenmeyen istek metodu.']);
        break;
}

$conn->close();
?> 