<?php

require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/QuestionAnswerService.php';
require_once __DIR__ . '/../config.php'; // API_KEY için

header('Content-Type: application/json');

if (!isset($_SERVER['HTTP_X_API_KEY']) || $_SERVER['HTTP_X_API_KEY'] !== API_KEY) {
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'Yetkisiz erişim.']);
    exit();
}

$response = ['status' => 'error', 'message' => 'Geçersiz istek.'];

if (isset($_GET['subCategoryId'])) {
    $subCategoryId = intval($_GET['subCategoryId']);
    $questionAnswerService = new QuestionAnswerService($conn);
    
    if ($subCategoryId > 0) {
        $packages = $questionAnswerService->getQuestionPackagesBySubcategoryId($subCategoryId);
        $response = ['status' => 'success', 'data' => $packages];
        if (empty($packages)) {
            $response['debug_info'] = "subCategoryId: $subCategoryId için paket bulunamadı.";
        } else {
            $response['debug_info'] = "subCategoryId: $subCategoryId için " . count($packages) . " paket bulundu.";
        }
    } else {
        // Eğer subCategoryId 0 ise (Paketsiz sorular için boş bırakın veya tüm paketler gibi bir seçenek varsa)
        // Şu an için boş bir liste döndürüyorum veya tüm paketleri getirebiliriz duruma göre.
        $packages = $questionAnswerService->getAllQuestionPackages(); // Eğer 0 ise tüm paketleri getirsin
        $response = ['status' => 'success', 'data' => $packages];
        $response['debug_info'] = "subCategoryId 0 veya eksi olduğu için tüm paketler getirildi: " . count($packages) . " paket bulundu.";
    }
} else {
    $response = ['status' => 'error', 'message' => 'subCategoryId parametresi eksik.', 'debug_info' => 'subCategoryId eksik.'];
}

echo json_encode($response);

?> 