<?php
require_once __DIR__ . '/../db_connect.php';
require_once __DIR__ . '/../services/QuestionAnswerService.php'; // Soru paketleri için
require_once __DIR__ . '/../services/SubcategoryService.php'; // Alt kategorileri çekmek için
require_once __DIR__ . '/../helpers/session_helper.php';

check_admin_session(); // Admin oturumunu kontrol et

$questionAnswerService = new QuestionAnswerService($conn);
$subcategoryService = new SubcategoryService($conn); // Alt kategori seçim kutusu için

// Soru paketi ekleme veya güncelleme işlemleri
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['action']) && $_POST['action'] == 'add_package') {
        $subCategoryId = intval($_POST['subCategoryId']);
        $title = trim($_POST['title']);
        $description = trim($_POST['description']);
        
        if (empty($title) || $subCategoryId <= 0) {
            set_session_message('error', "Paket başlığı ve alt kategori seçimi boş bırakılamaz.");
        } else {
            $result = $questionAnswerService->addQuestionPackage($subCategoryId, $title, $description);
            set_session_message($result['status'], $result['message']);
        }
    } elseif (isset($_POST['action']) && $_POST['action'] == 'edit_package') {
        $id = intval($_POST['package_id']);
        $subCategoryId = intval($_POST['subCategoryId']);
        $title = trim($_POST['title']);
        $description = trim($_POST['description']);

        if (empty($title) || $subCategoryId <= 0) {
            set_session_message('error', "Paket başlığı ve alt kategori seçimi boş bırakılamaz.");
        } else {
            $result = $questionAnswerService->updateQuestionPackage($id, $subCategoryId, $title, $description);
            set_session_message($result['status'], $result['message']);
        }
    }
    header("Location: question_packages.php"); // POST işlemi sonrası sayfayı yenile
    exit;
}

// Soru paketi silme işlemi
if (isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $result = $questionAnswerService->deleteQuestionPackage($id);
    set_session_message($result['status'], $result['message']);
    header("Location: question_packages.php");
    exit;
}

// Tüm soru paketlerini ve alt kategorileri çek
$questionPackages = $questionAnswerService->getAllQuestionPackages();
$subcategories = $subcategoryService->getAllSubcategoriesWithCategoryNames(); // Alt kategori seçim kutusu için

include '_head.php'; // Header'ı dahil et
?>

<h1 class="mb-4">Soru Paketleri</h1>
<?php display_session_message(); // Oturum mesajlarını göster ?>

<button type="button" class="btn btn-success mb-3" data-bs-toggle="modal" data-bs-target="#addPackageModal">
    Yeni Soru Paketi Ekle
</button>

<div class="table-responsive">
    <table class="table table-striped table-hover">
        <thead>
            <tr>
                <th>ID</th>
                <th>Kategori (Alt Kategori)</th>
                <th>Başlık</th>
                <th>Açıklama</th>
                <th>İşlemler</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($questionPackages)): ?>
                <?php foreach ($questionPackages as $package): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($package['id']); ?></td>
                        <td><?php echo htmlspecialchars($package['subcategory_name']); ?></td>
                        <td><?php echo htmlspecialchars($package['title']); ?></td>
                        <td><?php echo htmlspecialchars($package['description']); ?></td>
                        <td>
                            <button type="button" class="btn btn-sm btn-primary edit-btn" 
                                data-id="<?php echo htmlspecialchars($package['id']); ?>" 
                                data-subcategory-id="<?php echo htmlspecialchars($package['subCategoryId']); ?>" 
                                data-title="<?php echo htmlspecialchars($package['title']); ?>" 
                                data-description="<?php echo htmlspecialchars($package['description']); ?>"
                                data-bs-toggle="modal" data-bs-target="#editPackageModal">
                                Düzenle
                            </button>
                            <a href="question_packages.php?action=delete&id=<?php echo htmlspecialchars($package['id']); ?>" 
                                class="btn btn-sm btn-danger" 
                                onclick="return confirm('Bu soru paketini silmek istediğinizden emin misiniz? Bu işlem geri alınamaz!');">
                                Sil
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="5" class="text-center">Henüz hiç soru paketi yok.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- Yeni Soru Paketi Ekle Modal -->
<div class="modal fade" id="addPackageModal" tabindex="-1" aria-labelledby="addPackageModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="addPackageModalLabel">Yeni Soru Paketi Ekle</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <div class="modal-body">
          <input type="hidden" name="action" value="add_package">
          <div class="mb-3">
            <label for="add_subCategoryId" class="form-label">Alt Kategori Seçin</label>
            <select class="form-select" id="add_subCategoryId" name="subCategoryId" required>
              <option value="">Alt Kategori Seçiniz...</option>
              <?php foreach ($subcategories as $subcat): ?>
                <option value="<?php echo htmlspecialchars($subcat['id']); ?>"><?php echo htmlspecialchars($subcat['category_name']) . ' > ' . htmlspecialchars($subcat['name']); ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-3">
            <label for="add_title" class="form-label">Paket Başlığı</label>
            <input type="text" class="form-control" id="add_title" name="title" required>
          </div>
          <div class="mb-3">
            <label for="add_description" class="form-label">Açıklama (İsteğe Bağlı)</label>
            <textarea class="form-control" id="add_description" name="description" rows="3"></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
          <button type="submit" class="btn btn-primary">Paket Ekle</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Soru Paketi Düzenle Modal -->
<div class="modal fade" id="editPackageModal" tabindex="-1" aria-labelledby="editPackageModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editPackageModalLabel">Soru Paketi Düzenle</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <div class="modal-body">
          <input type="hidden" name="action" value="edit_package">
          <input type="hidden" name="package_id" id="edit_package_id">
          <div class="mb-3">
            <label for="edit_subCategoryId" class="form-label">Alt Kategori Seçin</label>
            <select class="form-select" id="edit_subCategoryId" name="subCategoryId" required>
              <option value="">Alt Kategori Seçiniz...</option>
              <?php foreach ($subcategories as $subcat): ?>
                <option value="<?php echo htmlspecialchars($subcat['id']); ?>"><?php echo htmlspecialchars($subcat['category_name']) . ' > ' . htmlspecialchars($subcat['name']); ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="mb-3">
            <label for="edit_title" class="form-label">Paket Başlığı</label>
            <input type="text" class="form-control" id="edit_title" name="title" required>
          </div>
          <div class="mb-3">
            <label for="edit_description" class="form-label">Açıklama (İsteğe Bağlı)</label>
            <textarea class="form-control" id="edit_description" name="description" rows="3"></textarea>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
          <button type="submit" class="btn btn-primary">Değişiklikleri Kaydet</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        var editPackageModal = document.getElementById('editPackageModal');
        editPackageModal.addEventListener('show.bs.modal', function (event) {
            var button = event.relatedTarget;
            var id = button.getAttribute('data-id');
            var subCategoryId = button.getAttribute('data-subcategory-id');
            var title = button.getAttribute('data-title');
            var description = button.getAttribute('data-description');

            var modalIdInput = editPackageModal.querySelector('#edit_package_id');
            var modalSubCategoryIdSelect = editPackageModal.querySelector('#edit_subCategoryId');
            var modalTitleInput = editPackageModal.querySelector('#edit_title');
            var modalDescriptionInput = editPackageModal.querySelector('#edit_description');

            modalIdInput.value = id;
            modalSubCategoryIdSelect.value = subCategoryId;
            modalTitleInput.value = title;
            modalDescriptionInput.value = description;
        });
    });
</script>

<?php include '_footer.php'; // Footer'ı dahil et ?> 